/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.adminui.gui;

import com.buuz135.adminui.AdminUIIndexRegistry;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import javax.annotation.Nonnull;

public class NavBarHelper {
    public static void setupBar(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder uiEventBuilder, @Nonnull Store<EntityStore> store) {
        int index = 0;
        uiCommandBuilder.appendInline("#AdminUITopNavigationBar #NavBarButtons", "Group #NavCards { LayoutMode: Left; }");
        for (AdminUIIndexRegistry.Entry entry : AdminUIIndexRegistry.getInstance().getEntries()) {
            uiCommandBuilder.append("#NavCards", "Pages/Nav/Buuz135_AdminUI_TopNavigationBarButton.ui");
            uiCommandBuilder.set("#NavBarButtons #NavCards[" + index + "] #NavActionButton.Text", entry.displayName());
            uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#NavBarButtons #NavCards[" + index + "] #NavActionButton", EventData.of((String)"NavBar", (String)entry.id()));
            ++index;
        }
    }

    public static boolean handleData(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, String navBarData, Runnable onCancel) {
        if (navBarData == null) {
            return false;
        }
        AdminUIIndexRegistry.Entry entry = AdminUIIndexRegistry.getInstance().getEntry(navBarData);
        if (entry == null) {
            return false;
        }
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        onCancel.run();
        player.getPageManager().openCustomPage(ref, store, (CustomUIPage)entry.guiSupplier().apply(playerRef));
        return true;
    }
}

