/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.adminui.gui;

import com.buuz135.adminui.AdminUI;
import com.buuz135.adminui.gui.AdminIndexGui;
import com.buuz135.adminui.gui.NavBarHelper;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.common.util.FormatUtil;
import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.protocol.packets.connection.PongType;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.protocol.packets.interface_.Page;
import com.hypixel.hytale.server.core.NameMatching;
import com.hypixel.hytale.server.core.asset.type.model.config.Model;
import com.hypixel.hytale.server.core.asset.type.model.config.ModelAsset;
import com.hypixel.hytale.server.core.cosmetics.CosmeticsModule;
import com.hypixel.hytale.server.core.entity.UUIDComponent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.windows.ContainerWindow;
import com.hypixel.hytale.server.core.entity.entities.player.windows.Window;
import com.hypixel.hytale.server.core.inventory.container.CombinedItemContainer;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.io.PacketHandler;
import com.hypixel.hytale.server.core.modules.accesscontrol.ban.InfiniteBan;
import com.hypixel.hytale.server.core.modules.entity.component.ModelComponent;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.modules.entity.damage.Damage;
import com.hypixel.hytale.server.core.modules.entity.damage.DamageCause;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathComponent;
import com.hypixel.hytale.server.core.modules.entity.player.PlayerSkinComponent;
import com.hypixel.hytale.server.core.modules.entity.teleport.Teleport;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatMap;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatValue;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatsModule;
import com.hypixel.hytale.server.core.modules.entitystats.asset.EntityStatType;
import com.hypixel.hytale.server.core.permissions.PermissionsModule;
import com.hypixel.hytale.server.core.ui.DropdownEntryInfo;
import com.hypixel.hytale.server.core.ui.LocalizableString;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class PlayerGui
extends InteractiveCustomUIPage<SearchGuiData> {
    private String searchQuery = "";
    private List<String> visibleItems = new ArrayList<String>();
    private List<String> expandedItems = new ArrayList<String>();

    public PlayerGui(@Nonnull PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismiss, SearchGuiData.CODEC);
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder uiEventBuilder, @Nonnull Store<EntityStore> store) {
        uiCommandBuilder.append("Pages/Player/Buuz135_AdminUI_PlayerPage.ui");
        NavBarHelper.setupBar(ref, uiCommandBuilder, uiEventBuilder, store);
        uiCommandBuilder.set("#SearchInput.Value", this.searchQuery);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#SearchInput", EventData.of((String)"@SearchQuery", (String)"#SearchInput.Value"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#BackButton", EventData.of((String)"Button", (String)"BackButton"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#KillAllButton", EventData.of((String)"Button", (String)"KillAllButton"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TeleportAllButton", EventData.of((String)"Button", (String)"TeleportAllButton"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#KickAllButton", EventData.of((String)"Button", (String)"KickAllButton"), false);
        this.buildList(ref, uiCommandBuilder, uiEventBuilder, store);
    }

    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull SearchGuiData data) {
        super.handleDataEvent(ref, store, (Object)data);
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (NavBarHelper.handleData(ref, store, data.navbar, () -> {})) {
            return;
        }
        if (data.button != null) {
            Ref otherReference;
            Iterator uuid;
            if (data.button.equals("BackButton")) {
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new AdminIndexGui(playerRef, CustomPageLifetime.CanDismiss));
                return;
            }
            if (data.button.equals("Heal")) {
                this.heal(store, UUID.fromString(data.uuid));
            }
            if (data.button.equals("Kill")) {
                this.kill(store, UUID.fromString(data.uuid));
            }
            if (data.button.equals("Inventory")) {
                this.inventory(store, UUID.fromString(data.uuid));
            }
            if (data.button.equals("Kick")) {
                this.kick(store, UUID.fromString(data.uuid));
            }
            if (data.button.equals("Ban")) {
                this.ban(store, UUID.fromString(data.uuid));
            }
            if (data.button.equals("GamemodeDropdown")) {
                uuid = UUID.fromString(data.uuid);
                GameMode gamemode = GameMode.valueOf((String)data.dropdownValue);
                Player.setGameMode((Ref)Universe.get().getPlayer((UUID)((Object)uuid)).getReference(), (GameMode)gamemode, store);
            }
            if (data.button.equals("ModelDropdown")) {
                uuid = UUID.fromString(data.uuid);
                ModelAsset model = AdminUI.MODELS.get(data.dropdownValue);
                Ref otherReference2 = Universe.get().getPlayer((UUID)((Object)uuid)).getReference();
                store.putComponent(otherReference2, ModelComponent.getComponentType(), (Component)new ModelComponent(Model.createScaledModel((ModelAsset)model, (float)model.generateRandomScale())));
                ((PlayerSkinComponent)store.getComponent(otherReference2, PlayerSkinComponent.getComponentType())).consumeNetworkOutdated();
            }
            if (data.button.equals("ResetModel")) {
                uuid = UUID.fromString(data.uuid);
                otherReference = Universe.get().getPlayer((UUID)((Object)uuid)).getReference();
                PlayerSkinComponent playerSkinComponent = (PlayerSkinComponent)store.getComponent(otherReference, PlayerSkinComponent.getComponentType());
                CosmeticsModule cosmeticsModule = CosmeticsModule.get();
                Model newModel = cosmeticsModule.createModel(playerSkinComponent.getPlayerSkin());
                store.putComponent(otherReference, ModelComponent.getComponentType(), (Component)new ModelComponent(newModel));
                playerSkinComponent.setNetworkOutdated();
            }
            if (data.button.equals("TeleportTo")) {
                uuid = UUID.fromString(data.uuid);
                otherReference = Universe.get().getPlayer((UUID)((Object)uuid)).getReference();
                TransformComponent positionTo = (TransformComponent)store.getComponent(otherReference, TransformComponent.getComponentType());
                this.teleport(store, ((UUIDComponent)store.getComponent(playerRef.getReference(), UUIDComponent.getComponentType())).getUuid(), new Teleport(((Player)store.getComponent(otherReference, Player.getComponentType())).getWorld(), positionTo.getPosition(), positionTo.getRotation()));
            }
            if (data.button.equals("TeleportHere")) {
                uuid = UUID.fromString(data.uuid);
                TransformComponent positionHere = (TransformComponent)store.getComponent(playerRef.getReference(), TransformComponent.getComponentType());
                this.teleport(store, (UUID)((Object)uuid), new Teleport(player.getWorld(), positionHere.getPosition(), positionHere.getRotation()));
            }
            if (data.button.equals("KillAllButton")) {
                for (PlayerRef player1 : Universe.get().getPlayers()) {
                    if (player1.getUuid().equals(playerRef.getUuid())) continue;
                    this.kill(store, player1.getUuid());
                }
            }
            if (data.button.equals("TeleportAllButton")) {
                for (PlayerRef player1 : Universe.get().getPlayers()) {
                    if (player1.getUuid().equals(playerRef.getUuid())) continue;
                    TransformComponent positionHere = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
                    this.teleport(store, player1.getUuid(), new Teleport(player.getWorld(), positionHere.getPosition(), positionHere.getRotation()));
                }
            }
            if (data.button.equals("KickAllButton")) {
                for (PlayerRef player1 : Universe.get().getPlayers()) {
                    if (player1.getUuid().equals(playerRef.getUuid())) continue;
                    this.kick(store, player1.getUuid());
                }
            }
            if (data.button.equals("ToggleExpanded")) {
                if (this.expandedItems.contains(data.uuid)) {
                    this.expandedItems.remove(data.uuid);
                } else {
                    this.expandedItems.add(data.uuid);
                }
            }
        }
        if (data.searchQuery != null) {
            this.searchQuery = data.searchQuery.trim().toLowerCase();
        }
        UICommandBuilder commandBuilder = new UICommandBuilder();
        UIEventBuilder eventBuilder = new UIEventBuilder();
        this.buildList(ref, commandBuilder, eventBuilder, store);
        this.sendUpdate(commandBuilder, eventBuilder, false);
    }

    private void buildList(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull Store<EntityStore> store) {
        List<String> players = Universe.get().getPlayers().stream().map(PlayerRef::getUsername).toList();
        Player playerComponent = (Player)store.getComponent(ref, Player.getComponentType());
        assert (playerComponent != null);
        if (this.searchQuery.isEmpty()) {
            this.visibleItems.clear();
            this.visibleItems.addAll(players);
        } else {
            this.visibleItems.clear();
            for (String entry : players) {
                if (!entry.toLowerCase().contains(this.searchQuery.toLowerCase())) continue;
                this.visibleItems.add(entry);
            }
        }
        this.buildButtons(this.visibleItems, playerComponent, commandBuilder, eventBuilder, store);
    }

    protected void close() {
        super.close();
    }

    private void buildButtons(List<String> items, @Nonnull Player playerComponent, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull Store<EntityStore> store) {
        uiCommandBuilder.clear("#IndexCards");
        uiCommandBuilder.appendInline("#Main #IndexList", "Group #IndexCards { LayoutMode: Left; }");
        List gamemodes = Arrays.stream(GameMode.values()).map(mode -> new DropdownEntryInfo(LocalizableString.fromString((String)mode.name()), mode.name())).collect(Collectors.toList());
        List<DropdownEntryInfo> models = AdminUI.MODELS.keySet().stream().map(model -> new DropdownEntryInfo(LocalizableString.fromString((String)model), model)).toList();
        int i = 0;
        for (String name : items) {
            PlayerRef playerRef = Universe.get().getPlayer(name, NameMatching.EXACT);
            Player player = (Player)store.getComponent(playerRef.getReference(), Player.getComponentType());
            EntityStatMap entityStatMap = (EntityStatMap)store.getComponent(playerRef.getReference(), EntityStatsModule.get().getEntityStatMapComponentType());
            int health = EntityStatType.getAssetMap().getIndex((Object)"Health");
            UUID uuid = playerRef.getUuid();
            PermissionsModule perms = PermissionsModule.get();
            TransformComponent position = (TransformComponent)store.getComponent(playerRef.getReference(), TransformComponent.getComponentType());
            uiCommandBuilder.append("#IndexCards", "Pages/Player/Buuz135_AdminUI_PlayerEntry.ui");
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "]", EventData.of((String)"Button", (String)"ToggleExpanded").append("UUID", name), false);
            if (this.expandedItems.contains(name)) {
                uiCommandBuilder.set("#IndexCards[" + i + "] #ExtendedInfo.Visible", true);
                uiCommandBuilder.set("#IndexCards[" + i + "] #ExpandedIcon.Visible", false);
                uiCommandBuilder.set("#IndexCards[" + i + "] #ExpandedIconDown.Visible", true);
            }
            uiCommandBuilder.set("#IndexCards[" + i + "] #MemberName.Text", name);
            uiCommandBuilder.set("#IndexCards[" + i + "] #MemberUUID.Text", uuid.toString());
            uiCommandBuilder.set("#IndexCards[" + i + "] #Ping.Text", "Ping: " + FormatUtil.simpleTimeUnitFormat((long)((long)playerRef.getPacketHandler().getPingInfo(PongType.Raw).getPingMetricSet().getAverage(0)), (TimeUnit)PacketHandler.PingInfo.TIME_UNIT, (int)0));
            uiCommandBuilder.set("#IndexCards[" + i + "] #IsOp.Visible", perms.getGroupsForUser(uuid).contains("OP"));
            uiCommandBuilder.set("#IndexCards[" + i + "] #IsWhitelisted.Visible", AdminUI.getInstance().getWhitelistProvider().getList().contains(uuid));
            uiCommandBuilder.set("#IndexCards[" + i + "] #HealthValue.Text", (int)entityStatMap.get(health).asPercentage() * 100 + "%");
            uiCommandBuilder.set("#IndexCards[" + i + "] #WorldValue.Text", player != null && player.getWorld() != null ? player.getWorld().getName() : "Unknown");
            uiCommandBuilder.set("#IndexCards[" + i + "] #XValue.Text", "" + (int)position.getPosition().getX());
            uiCommandBuilder.set("#IndexCards[" + i + "] #YValue.Text", "" + (int)position.getPosition().getY());
            uiCommandBuilder.set("#IndexCards[" + i + "] #ZValue.Text", "" + (int)position.getPosition().getZ());
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #TeleportToButton", EventData.of((String)"Button", (String)"TeleportTo").append("UUID", uuid.toString()), false);
            uiCommandBuilder.set("#IndexCards[" + i + "] #GamemodeDropdown.Entries", gamemodes);
            uiCommandBuilder.set("#IndexCards[" + i + "] #GamemodeDropdown.Value", player != null ? player.getGameMode().name() : "Unknown");
            eventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#IndexCards[" + i + "] #GamemodeDropdown", EventData.of((String)"Button", (String)"GamemodeDropdown").append("UUID", uuid.toString()).append("@DropdownValue", "#IndexCards[" + i + "] #GamemodeDropdown.Value"), false);
            uiCommandBuilder.set("#IndexCards[" + i + "] #ModelDropdown.Entries", models);
            uiCommandBuilder.set("#IndexCards[" + i + "] #ModelDropdown.Value", ((ModelComponent)store.getComponent(playerRef.getReference(), ModelComponent.getComponentType())).getModel().getModelAssetId());
            eventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#IndexCards[" + i + "] #ModelDropdown", EventData.of((String)"Button", (String)"ModelDropdown").append("UUID", uuid.toString()).append("@DropdownValue", "#IndexCards[" + i + "] #ModelDropdown.Value"), false);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #ModelResetButton", EventData.of((String)"Button", (String)"ResetModel").append("UUID", uuid.toString()), false);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #HealButton", EventData.of((String)"Button", (String)"Heal").append("UUID", uuid.toString()), false);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #KillButton", EventData.of((String)"Button", (String)"Kill").append("UUID", uuid.toString()), false);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #InventoryButton", EventData.of((String)"Button", (String)"Inventory").append("UUID", uuid.toString()), false);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #KickButton", EventData.of((String)"Button", (String)"Kick").append("UUID", uuid.toString()), false);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #BanButton", EventData.of((String)"Button", (String)"Ban").append("UUID", uuid.toString()), false);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #TeleportHereButton", EventData.of((String)"Button", (String)"TeleportHere").append("UUID", uuid.toString()), false);
            ++i;
        }
    }

    public void heal(Store<EntityStore> store, UUID uuid) {
        PlayerRef entity = Universe.get().getPlayer(uuid);
        EntityStatMap entityStatMap = (EntityStatMap)store.getComponent(entity.getReference(), EntityStatsModule.get().getEntityStatMapComponentType());
        int health = EntityStatType.getAssetMap().getIndex((Object)"Health");
        int stamina = EntityStatType.getAssetMap().getIndex((Object)"Stamina");
        EntityStatValue healthStatValue = entityStatMap.get(health);
        entityStatMap.setStatValue(health, healthStatValue.getMax());
        EntityStatValue staminaStatValue = entityStatMap.get(stamina);
        entityStatMap.setStatValue(stamina, staminaStatValue.getMax());
    }

    public void kill(Store<EntityStore> store, UUID uuid) {
        PlayerRef entity = Universe.get().getPlayer(uuid);
        Damage.EnvironmentSource damageSource = new Damage.EnvironmentSource("ADMIN");
        DeathComponent.tryAddComponent(store, (Ref)entity.getReference(), (Damage)new Damage((Damage.Source)damageSource, DamageCause.COMMAND, 2.1474836E9f));
    }

    public void inventory(Store<EntityStore> store, UUID uuid) {
        CombinedItemContainer targetInventory;
        PlayerRef entity = Universe.get().getPlayer(uuid);
        Ref ref = entity.getReference();
        Player targetPlayerComponent = (Player)store.getComponent(ref, Player.getComponentType());
        CombinedItemContainer targetItemContainer = targetInventory = targetPlayerComponent.getInventory().getCombinedHotbarFirst();
        Player owner = (Player)store.getComponent(this.playerRef.getReference(), Player.getComponentType());
        owner.getPageManager().setPageWithWindows(ref, store, Page.Bench, true, new Window[]{new ContainerWindow((ItemContainer)targetItemContainer)});
    }

    public void kick(Store<EntityStore> store, UUID uuid) {
        PlayerRef entity = Universe.get().getPlayer(uuid);
        Ref ref = entity.getReference();
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        playerRef.getPacketHandler().disconnect("You were kicked by an admin.");
    }

    public void teleport(Store<EntityStore> store, UUID uuid, Teleport teleport) {
        PlayerRef entity = Universe.get().getPlayer(uuid);
        Ref ref = entity.getReference();
        store.putComponent(ref, Teleport.getComponentType(), (Component)teleport);
    }

    public void ban(Store<EntityStore> store, UUID uuid) {
        PlayerRef entity = Universe.get().getPlayer(uuid);
        Ref ref = entity.getReference();
        InfiniteBan ban = new InfiniteBan(uuid, ((UUIDComponent)store.getComponent(this.playerRef.getReference(), UUIDComponent.getComponentType())).getUuid(), Instant.now(), "You were banned by an admin.");
        if (AdminUI.getInstance().getBanProvider().modify(uuids -> {
            uuids.put(uuid, ban);
            return true;
        })) {
            PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
            playerRef.getPacketHandler().disconnect("You were banned by an admin.");
        }
    }

    public static class SearchGuiData {
        static final String KEY_BUTTON = "Button";
        static final String KEY_NAVBAR = "NavBar";
        static final String KEY_UUID = "UUID";
        static final String KEY_SEARCH_QUERY = "@SearchQuery";
        static final String KEY_DROPDOWN_VALUE_QUERY = "@DropdownValue";
        public static final BuilderCodec<SearchGuiData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(SearchGuiData.class, SearchGuiData::new).addField(new KeyedCodec("@SearchQuery", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.searchQuery = s;
        }, searchGuiData -> searchGuiData.searchQuery)).addField(new KeyedCodec("UUID", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.uuid = s;
        }, searchGuiData -> searchGuiData.uuid)).addField(new KeyedCodec("Button", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.button = s;
        }, searchGuiData -> searchGuiData.button)).addField(new KeyedCodec("@DropdownValue", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.dropdownValue = s;
        }, searchGuiData -> searchGuiData.dropdownValue)).addField(new KeyedCodec("NavBar", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.navbar = s;
        }, searchGuiData -> searchGuiData.navbar)).build();
        private String button;
        private String searchQuery;
        private String uuid;
        private String dropdownValue;
        private String navbar;
    }
}

