/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.adminui.gui;

import com.buuz135.adminui.gui.AdminIndexGui;
import com.buuz135.adminui.gui.NavBarHelper;
import com.hypixel.hytale.builtin.teleport.TeleportPlugin;
import com.hypixel.hytale.builtin.teleport.Warp;
import com.hypixel.hytale.builtin.teleport.components.TeleportHistory;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.modules.entity.component.HeadRotation;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.modules.entity.teleport.Teleport;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class WarpGui
extends InteractiveCustomUIPage<SearchGuiData> {
    private String searchQuery = "";
    private HashMap<String, Warp> visibleItems = new LinkedHashMap<String, Warp>();
    private int requestingConfirmation = -1;
    private String inputField;

    public WarpGui(@Nonnull PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismiss, SearchGuiData.CODEC);
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder uiEventBuilder, @Nonnull Store<EntityStore> store) {
        uiCommandBuilder.append("Pages/Warp/Buuz135_AdminUI_WarpPage.ui");
        NavBarHelper.setupBar(ref, uiCommandBuilder, uiEventBuilder, store);
        uiCommandBuilder.set("#SearchInput.Value", this.searchQuery);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#SearchInput", EventData.of((String)"@SearchQuery", (String)"#SearchInput.Value"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#BackButton", EventData.of((String)"Button", (String)"BackButton"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#NewWarpField", EventData.of((String)"@InputField", (String)"#NewWarpField.Value"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#AddWarpButton", EventData.of((String)"Button", (String)"AddWarpButton"), false);
        this.buildList(ref, uiCommandBuilder, uiEventBuilder, (ComponentAccessor<EntityStore>)store);
    }

    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull SearchGuiData data) {
        super.handleDataEvent(ref, store, (Object)data);
        if (NavBarHelper.handleData(ref, store, data.navbar, () -> {})) {
            return;
        }
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (data.button != null) {
            if (data.button.equals("BackButton")) {
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new AdminIndexGui(playerRef, CustomPageLifetime.CanDismiss));
                return;
            }
            if (data.button.equals("AddWarpButton")) {
                TransformComponent transformComponent = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
                assert (transformComponent != null);
                HeadRotation headRotationComponent = (HeadRotation)store.getComponent(ref, HeadRotation.getComponentType());
                assert (headRotationComponent != null);
                Vector3d position = transformComponent.getPosition();
                Vector3f rotation = transformComponent.getRotation();
                Vector3f headRotation = headRotationComponent.getRotation();
                Warp newWarp = new Warp(position.getX(), position.getY(), position.getZ(), headRotation.getYaw(), rotation.getPitch(), rotation.getRoll(), this.inputField.toLowerCase(), player.getWorld(), playerRef.getUsername(), Instant.now());
                TeleportPlugin.get().getWarps().put(newWarp.getId(), newWarp);
                TeleportPlugin.get().saveWarps();
                UICommandBuilder commandBuilder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
                this.sendUpdate(commandBuilder, eventBuilder, false);
                return;
            }
            if (data.button.startsWith("Go")) {
                String[] split = data.button.split(":");
                String id = split[1];
                Warp warp = (Warp)TeleportPlugin.get().getWarps().get(id);
                if (warp == null) {
                    return;
                }
                TransformComponent transformComponent = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
                assert (transformComponent != null);
                HeadRotation headRotationComponent = (HeadRotation)store.getComponent(ref, HeadRotation.getComponentType());
                assert (headRotationComponent != null);
                Vector3d playerPosition = transformComponent.getPosition();
                Vector3f playerHeadRotation = headRotationComponent.getRotation();
                ((TeleportHistory)store.ensureAndGetComponent(ref, TeleportHistory.getComponentType())).append(player.getWorld(), playerPosition.clone(), playerHeadRotation.clone(), "Warp '" + String.valueOf(warp) + "'");
                store.addComponent(ref, Teleport.getComponentType(), (Component)warp.toTeleport());
                playerRef.sendMessage(Message.translation((String)"commands.teleport.warp.warpedTo").param("name", warp.getId()));
                return;
            }
        }
        if (data.inputField != null) {
            this.inputField = data.inputField;
        }
        if (data.removeButtonAction != null) {
            String[] split = data.removeButtonAction.split(":");
            String action = split[0];
            if (action.equals("Click")) {
                int index;
                this.requestingConfirmation = index = Integer.parseInt(split[1]);
            }
            if (action.equals("Delete")) {
                TeleportPlugin.get().getWarps().remove(split[1]);
                TeleportPlugin.get().saveWarps();
                this.requestingConfirmation = -1;
            }
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
            this.sendUpdate(commandBuilder, eventBuilder, false);
            return;
        }
        if (data.searchQuery != null) {
            this.searchQuery = data.searchQuery.trim().toLowerCase();
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
            this.sendUpdate(commandBuilder, eventBuilder, false);
        }
    }

    private void buildList(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull ComponentAccessor<EntityStore> componentAccessor) {
        HashMap itemList = new HashMap();
        itemList.putAll(TeleportPlugin.get().getWarps());
        Player playerComponent = (Player)componentAccessor.getComponent(ref, Player.getComponentType());
        assert (playerComponent != null);
        if (this.searchQuery.isEmpty()) {
            this.visibleItems.clear();
            this.visibleItems.putAll(itemList);
        } else {
            this.visibleItems.clear();
            for (Map.Entry entry : itemList.entrySet()) {
                if (!((Warp)entry.getValue()).getId().toLowerCase().contains(this.searchQuery.toLowerCase())) continue;
                this.visibleItems.put((String)entry.getKey(), (Warp)entry.getValue());
            }
        }
        this.buildButtons(this.visibleItems, playerComponent, commandBuilder, eventBuilder);
    }

    private void buildButtons(HashMap<String, Warp> items, @Nonnull Player playerComponent, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder eventBuilder) {
        uiCommandBuilder.clear("#IndexCards");
        uiCommandBuilder.appendInline("#Main #IndexList", "Group #IndexCards { LayoutMode: Left; }");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm").withZone(ZoneId.systemDefault());
        int i = 0;
        for (Map.Entry<String, Warp> warpEntry : items.entrySet()) {
            uiCommandBuilder.append("#IndexCards", "Pages/Warp/Buuz135_AdminUI_WarpEntry.ui");
            uiCommandBuilder.set("#IndexCards[" + i + "] #WarpName.Text", warpEntry.getValue().getId());
            uiCommandBuilder.set("#IndexCards[" + i + "] #WarpBy.Text", "By " + warpEntry.getValue().getCreator());
            uiCommandBuilder.set("#IndexCards[" + i + "] #WarpWhen.Text", formatter.format(warpEntry.getValue().getCreationDate()));
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #GoButton", EventData.of((String)"Button", (String)("Go:" + warpEntry.getValue().getId())), false);
            uiCommandBuilder.set("#IndexCards[" + i + "] #WorldValue.Text", warpEntry.getValue().getWorld());
            uiCommandBuilder.set("#IndexCards[" + i + "] #XValue.Text", "" + (int)warpEntry.getValue().getTransform().getPosition().getX());
            uiCommandBuilder.set("#IndexCards[" + i + "] #YValue.Text", "" + (int)warpEntry.getValue().getTransform().getPosition().getY());
            uiCommandBuilder.set("#IndexCards[" + i + "] #ZValue.Text", "" + (int)warpEntry.getValue().getTransform().getPosition().getZ());
            if (this.requestingConfirmation == i) {
                uiCommandBuilder.set("#IndexCards[" + i + "] #RemoveWarpButton.Text", "Are you sure?");
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #RemoveWarpButton", EventData.of((String)"RemoveButtonAction", (String)("Delete:" + warpEntry.getValue().getId())), false);
                eventBuilder.addEventBinding(CustomUIEventBindingType.MouseExited, "#IndexCards[" + i + "] #RemoveWarpButton", EventData.of((String)"RemoveButtonAction", (String)"Click:-1"), false);
            } else {
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #RemoveWarpButton", EventData.of((String)"RemoveButtonAction", (String)("Click:" + i)), false);
            }
            ++i;
        }
    }

    public static class SearchGuiData {
        static final String KEY_BUTTON = "Button";
        static final String KEY_REMOVE_BUTTON_ACTION = "RemoveButtonAction";
        static final String KEY_SEARCH_QUERY = "@SearchQuery";
        static final String KEY_INPUT_FIELD = "@InputField";
        static final String KEY_NAVBAR = "NavBar";
        public static final BuilderCodec<SearchGuiData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(SearchGuiData.class, SearchGuiData::new).addField(new KeyedCodec("@SearchQuery", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.searchQuery = s;
        }, searchGuiData -> searchGuiData.searchQuery)).addField(new KeyedCodec("Button", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.button = s;
        }, searchGuiData -> searchGuiData.button)).addField(new KeyedCodec("RemoveButtonAction", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.removeButtonAction = s;
        }, searchGuiData -> searchGuiData.removeButtonAction)).addField(new KeyedCodec("@InputField", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.inputField = s;
        }, searchGuiData -> searchGuiData.inputField)).addField(new KeyedCodec("NavBar", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.navbar = s;
        }, searchGuiData -> searchGuiData.navbar)).build();
        private String button;
        private String searchQuery;
        private String removeButtonAction;
        private String inputField;
        private String navbar;
    }
}

