/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.adminui.gui;

import com.buuz135.adminui.AdminUI;
import com.buuz135.adminui.gui.AdminIndexGui;
import com.buuz135.adminui.gui.NavBarHelper;
import com.buuz135.adminui.util.PlayerTracker;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.AuthUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public class WhitelistGui
extends InteractiveCustomUIPage<SearchGuiData> {
    private String searchQuery = "";
    private HashMap<UUID, String> visibleItems = new LinkedHashMap<UUID, String>();
    private int requestingConfirmation = -1;
    private String inputField;

    public WhitelistGui(@Nonnull PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismiss, SearchGuiData.CODEC);
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder uiEventBuilder, @Nonnull Store<EntityStore> store) {
        uiCommandBuilder.append("Pages/Whitelist/Buuz135_AdminUI_WhitelistPage.ui");
        NavBarHelper.setupBar(ref, uiCommandBuilder, uiEventBuilder, store);
        uiCommandBuilder.set("#SearchInput.Value", this.searchQuery);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#SearchInput", EventData.of((String)"@SearchQuery", (String)"#SearchInput.Value"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#BackButton", EventData.of((String)"Button", (String)"BackButton"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#WhitelistSetting #CheckBox", EventData.of((String)"Button", (String)"WhitelistSetting"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#NewWhitelistField", EventData.of((String)"@InputField", (String)"#NewWhitelistField.Value"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#AddToWhitelistButton", EventData.of((String)"Button", (String)"AddMemberButton"), false);
        uiCommandBuilder.set("#WhitelistSetting #CheckBox.Value", AdminUI.getInstance().getWhitelistProvider().isEnabled());
        this.buildList(ref, uiCommandBuilder, uiEventBuilder, (ComponentAccessor<EntityStore>)store);
    }

    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull SearchGuiData data) {
        super.handleDataEvent(ref, store, (Object)data);
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (NavBarHelper.handleData(ref, store, data.navbar, () -> {})) {
            return;
        }
        if (data.button != null) {
            if (data.button.equals("BackButton")) {
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new AdminIndexGui(playerRef, CustomPageLifetime.CanDismiss));
                return;
            }
            if (data.button.equals("WhitelistSetting")) {
                AdminUI.getInstance().getWhitelistProvider().setEnabled(!AdminUI.getInstance().getWhitelistProvider().isEnabled());
                AdminUI.getInstance().getWhitelistProvider().syncSave();
                if (AdminUI.getInstance().getWhitelistProvider().isEnabled()) {
                    player.sendMessage(Message.translation((String)"server.modules.whitelist.enabled"));
                } else {
                    player.sendMessage(Message.translation((String)"server.modules.whitelist.disabled"));
                }
                return;
            }
            if (data.button.equals("AddMemberButton")) {
                UUID uuid = null;
                PlayerTracker.Players playerTracker = AdminUI.getInstance().getPlayerTracker().getPlayer(this.inputField);
                if (playerTracker != null) {
                    uuid = playerTracker.uuid();
                } else {
                    player.sendMessage(Message.raw((String)"That player hasn't joined the server yet, the whitelist is not reliable"));
                    try {
                        uuid = (UUID)AuthUtil.lookupUuid((String)this.inputField).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (uuid == null) {
                    return;
                }
                UUID finalUuid = uuid;
                if (AdminUI.getInstance().getWhitelistProvider().modify(uuids -> uuids.add(finalUuid))) {
                    AdminUI.getInstance().getWhitelistProvider().syncSave();
                    player.sendMessage(Message.translation((String)"server.modules.whitelist.addSuccess").param("name", this.inputField));
                    UICommandBuilder commandBuilder = new UICommandBuilder();
                    UIEventBuilder eventBuilder = new UIEventBuilder();
                    this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
                    this.sendUpdate(commandBuilder, eventBuilder, false);
                    return;
                }
                player.sendMessage(Message.translation((String)"server.modules.whitelist.alreadyWhitelisted").param("name", this.inputField));
                return;
            }
        }
        if (data.inputField != null) {
            this.inputField = data.inputField;
        }
        if (data.removeButtonAction != null) {
            String[] split = data.removeButtonAction.split(":");
            String action = split[0];
            if (action.equals("Click")) {
                int index;
                this.requestingConfirmation = index = Integer.parseInt(split[1]);
            }
            if (action.equals("Delete")) {
                UUID uuid = UUID.fromString(split[1]);
                AdminUI.getInstance().getWhitelistProvider().modify(uuids -> uuids.remove(uuid));
                AdminUI.getInstance().getWhitelistProvider().syncSave();
                player.sendMessage(Message.translation((String)"server.modules.whitelist.removalSuccess").param("uuid", uuid.toString()));
                this.requestingConfirmation = -1;
            }
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
            this.sendUpdate(commandBuilder, eventBuilder, false);
            return;
        }
        if (data.searchQuery != null) {
            this.searchQuery = data.searchQuery.trim().toLowerCase();
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
            this.sendUpdate(commandBuilder, eventBuilder, false);
        }
    }

    private void buildList(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull ComponentAccessor<EntityStore> componentAccessor) {
        HashMap<UUID, String> itemList = new HashMap<UUID, String>();
        for (UUID uuid : AdminUI.getInstance().getWhitelistProvider().getList()) {
            PlayerTracker.Players tracker = AdminUI.getInstance().getPlayerTracker().getPlayer(uuid);
            itemList.put(uuid, tracker == null ? "Unknown" : tracker.name());
        }
        Player playerComponent = (Player)componentAccessor.getComponent(ref, Player.getComponentType());
        assert (playerComponent != null);
        if (this.searchQuery.isEmpty()) {
            this.visibleItems.clear();
            this.visibleItems.putAll(itemList);
        } else {
            this.visibleItems.clear();
            for (Map.Entry entry : itemList.entrySet()) {
                if (!((String)entry.getValue()).toLowerCase().contains(this.searchQuery.toLowerCase())) continue;
                this.visibleItems.put((UUID)entry.getKey(), (String)entry.getValue());
            }
        }
        this.buildButtons(this.visibleItems, playerComponent, commandBuilder, eventBuilder);
    }

    private void buildButtons(HashMap<UUID, String> items, @Nonnull Player playerComponent, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder eventBuilder) {
        uiCommandBuilder.clear("#IndexCards");
        uiCommandBuilder.appendInline("#Main #IndexList", "Group #IndexCards { LayoutMode: Left; }");
        int i = 0;
        for (Map.Entry<UUID, String> name : items.entrySet()) {
            uiCommandBuilder.append("#IndexCards", "Pages/Whitelist/Buuz135_AdminUI_WhitelistEntry.ui");
            uiCommandBuilder.set("#IndexCards[" + i + "] #MemberName.Text", name.getValue());
            uiCommandBuilder.set("#IndexCards[" + i + "] #MemberUUID.Text", name.getKey().toString());
            if (this.requestingConfirmation == i) {
                uiCommandBuilder.set("#IndexCards[" + i + "] #RemoveMemberButton.Text", "Are you sure?");
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("Delete:" + name.getKey().toString())), false);
                eventBuilder.addEventBinding(CustomUIEventBindingType.MouseExited, "#IndexCards[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)"Click:-1"), false);
            } else {
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#IndexCards[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("Click:" + i)), false);
            }
            ++i;
        }
    }

    public static class SearchGuiData {
        static final String KEY_BUTTON = "Button";
        static final String KEY_REMOVE_BUTTON_ACTION = "RemoveButtonAction";
        static final String KEY_SEARCH_QUERY = "@SearchQuery";
        static final String KEY_INPUT_FIELD = "@InputField";
        static final String KEY_NAVBAR = "NavBar";
        public static final BuilderCodec<SearchGuiData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(SearchGuiData.class, SearchGuiData::new).addField(new KeyedCodec("@SearchQuery", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.searchQuery = s;
        }, searchGuiData -> searchGuiData.searchQuery)).addField(new KeyedCodec("Button", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.button = s;
        }, searchGuiData -> searchGuiData.button)).addField(new KeyedCodec("RemoveButtonAction", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.removeButtonAction = s;
        }, searchGuiData -> searchGuiData.removeButtonAction)).addField(new KeyedCodec("@InputField", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.inputField = s;
        }, searchGuiData -> searchGuiData.inputField)).addField(new KeyedCodec("NavBar", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.navbar = s;
        }, searchGuiData -> searchGuiData.navbar)).build();
        private String button;
        private String searchQuery;
        private String removeButtonAction;
        private String inputField;
        private String navbar;
    }
}

