/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.adminui.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hypixel.hytale.server.core.util.io.BlockingDiskFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;

public class BackupConfiguration
extends BlockingDiskFile {
    private boolean enabled = true;
    private String folder = "backups";
    private int retentionAmount = 10;
    private int backupFrequency = 60;

    public BackupConfiguration() {
        super(Path.of("AdminUI/Backup.json", new String[0]));
    }

    protected void read(BufferedReader bufferedReader) throws IOException {
        JsonObject object = JsonParser.parseReader((Reader)bufferedReader).getAsJsonObject();
        this.enabled = object.get("enabled").getAsBoolean();
        this.folder = object.get("folder").getAsString();
        this.retentionAmount = object.get("retentionAmount").getAsInt();
        this.backupFrequency = object.get("backupFrequency").getAsInt();
    }

    protected void write(BufferedWriter bufferedWriter) throws IOException {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("folder", this.folder);
        object.addProperty("retentionAmount", (Number)this.retentionAmount);
        object.addProperty("backupFrequency", (Number)this.backupFrequency);
        bufferedWriter.write(object.toString());
    }

    protected void create(BufferedWriter bufferedWriter) throws IOException {
        this.write(bufferedWriter);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public int getRetentionAmount() {
        return this.retentionAmount;
    }

    public void setRetentionAmount(int retentionAmount) {
        this.retentionAmount = retentionAmount;
    }

    public int getBackupFrequency() {
        return this.backupFrequency;
    }

    public void setBackupFrequency(int backupFrequency) {
        this.backupFrequency = backupFrequency;
    }
}

