/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.bettermodlist.gui;

import com.hypixel.hytale.assetstore.AssetPack;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.common.plugin.AuthorInfo;
import com.hypixel.hytale.common.plugin.PluginManifest;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.asset.AssetModule;
import com.hypixel.hytale.server.core.asset.common.CommonAssetRegistry;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.plugin.PluginManager;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ModListGui
extends InteractiveCustomUIPage<SearchGuiData> {
    private String searchQuery = "";
    private final List<CustomManifest> visibleItems = new ArrayList<CustomManifest>();
    private boolean showOnlyWithDescription = true;
    private boolean showHytale = true;
    private final List<PluginManifest> plugins = new ArrayList(PluginManager.get().getAvailablePlugins().values());
    private final List<PluginManifest> assetPacks = new ArrayList<PluginManifest>(AssetModule.get().getAssetPacks().stream().map(AssetPack::getManifest).toList());

    public ModListGui(@Nonnull PlayerRef playerRef, @Nonnull CustomPageLifetime lifetime) {
        super(playerRef, lifetime, SearchGuiData.CODEC);
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder uiEventBuilder, @Nonnull Store<EntityStore> store) {
        uiCommandBuilder.append("Pages/Buuz135_BetterModlist_Gui.ui");
        uiCommandBuilder.set("#SearchInput.Value", this.searchQuery);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#SearchInput", EventData.of((String)"@SearchQuery", (String)"#SearchInput.Value"), false);
        uiCommandBuilder.set("#ShowOnlyWithDesc #CheckBox.Value", this.showOnlyWithDescription);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ShowOnlyWithDesc #CheckBox", EventData.of((String)"ShowOnlyDesc", (String)"CAT"), false);
        uiCommandBuilder.set("#ShowHytale #CheckBox.Value", this.showHytale);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ShowHytale #CheckBox", EventData.of((String)"ShowHytale", (String)"CAT"), false);
        this.buildList(ref, uiCommandBuilder, uiEventBuilder, (ComponentAccessor<EntityStore>)store);
    }

    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull SearchGuiData data) {
        UIEventBuilder eventBuilder;
        UICommandBuilder commandBuilder;
        super.handleDataEvent(ref, store, (Object)data);
        if (data.showOnlyDesc != null) {
            this.showOnlyWithDescription = !this.showOnlyWithDescription;
            commandBuilder = new UICommandBuilder();
            eventBuilder = new UIEventBuilder();
            this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
            this.sendUpdate(commandBuilder, eventBuilder, false);
        }
        if (data.showHytale != null) {
            this.showHytale = !this.showHytale;
            commandBuilder = new UICommandBuilder();
            eventBuilder = new UIEventBuilder();
            this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
            this.sendUpdate(commandBuilder, eventBuilder, false);
        }
        if (data.searchQuery != null) {
            this.searchQuery = data.searchQuery.trim().toLowerCase();
            commandBuilder = new UICommandBuilder();
            eventBuilder = new UIEventBuilder();
            this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
            this.sendUpdate(commandBuilder, eventBuilder, false);
        }
    }

    private void buildList(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull ComponentAccessor<EntityStore> componentAccessor) {
        Player playerComponent = (Player)componentAccessor.getComponent(ref, Player.getComponentType());
        assert (playerComponent != null);
        ArrayList<CustomManifest> itemList = new ArrayList<CustomManifest>(this.plugins.stream().map(value -> new CustomManifest(this, (PluginManifest)value, false)).toList());
        for (PluginManifest value2 : this.assetPacks) {
            if (itemList.stream().anyMatch(pluginManifest -> pluginManifest.manifest.getGroup().equals(value2.getGroup()) && pluginManifest.manifest.getName().equals(value2.getName()))) continue;
            itemList.add(new CustomManifest(this, value2, true));
        }
        itemList.sort(Comparator.comparing(customManifest -> customManifest.manifest.getName()));
        if (this.searchQuery.isEmpty()) {
            this.visibleItems.clear();
            for (CustomManifest pluginManifest2 : itemList) {
                if (this.showOnlyWithDescription && pluginManifest2.manifest.getDescription() == null || !this.showHytale && pluginManifest2.manifest.getGroup().equals("Hytale")) continue;
                this.visibleItems.add(pluginManifest2);
            }
        } else {
            this.visibleItems.clear();
            for (CustomManifest pluginManifest2 : itemList) {
                String description;
                if (this.showOnlyWithDescription && pluginManifest2.manifest.getDescription() == null || !this.showHytale && pluginManifest2.manifest.getGroup().equals("Hytale")) continue;
                if (pluginManifest2.manifest.getName().toLowerCase().contains(this.searchQuery)) {
                    this.visibleItems.add(pluginManifest2);
                    continue;
                }
                String string = description = pluginManifest2.manifest.getDescription() != null ? pluginManifest2.manifest.getDescription() : "No description";
                if (description.contains(this.searchQuery)) {
                    this.visibleItems.add(pluginManifest2);
                    continue;
                }
                if (!pluginManifest2.manifest.getAuthors().stream().anyMatch(authorInfo -> authorInfo.getName().toLowerCase().contains(this.searchQuery))) continue;
                this.visibleItems.add(pluginManifest2);
            }
        }
        this.buildButtons(this.visibleItems, playerComponent, commandBuilder, eventBuilder);
    }

    private void buildButtons(List<CustomManifest> list, @Nonnull Player playerComponent, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder eventBuilder) {
        uiCommandBuilder.clear("#ModCards");
        uiCommandBuilder.appendInline("#Main #ModList", "Group #ModCards { LayoutMode: Left; }");
        for (int i = 0; i < list.size(); ++i) {
            this.generateModList(list.get((int)i).manifest, list.get((int)i).isAssetPack, i, playerComponent, uiCommandBuilder, eventBuilder);
        }
    }

    private void generateModList(PluginManifest value, boolean isAssetPack, int i, @Nonnull Player playerComponent, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder eventBuilder) {
        uiCommandBuilder.append("#ModCards", "Pages/Buuz135_BetterModlist_Entry.ui");
        uiCommandBuilder.set("#ModCards[" + i + "] #ModName.Text", value.getName());
        if (value.getDescription() != null) {
            uiCommandBuilder.set("#ModCards[" + i + "] #ModDescription.Text", value.getDescription());
        } else {
            uiCommandBuilder.remove("#ModCards[" + i + "] #ModDescription");
        }
        String version = "v" + String.valueOf(value.getVersion());
        while (version.length() < 8) {
            version = " " + version + " ";
        }
        uiCommandBuilder.set("#ModCards[" + i + "] #ModVersion.Text", version);
        Object authors = "By: ";
        authors = value.getAuthors().isEmpty() ? (String)authors + value.getGroup() : (String)authors + value.getAuthors().stream().map(AuthorInfo::getName).reduce((a, b) -> a + ", " + b).orElse("");
        uiCommandBuilder.set("#ModCards[" + i + "] #AuthorList.Text", (String)authors);
        if (isAssetPack) {
            uiCommandBuilder.set("#ModCards[" + i + "] #Enabled.Visible", true);
            uiCommandBuilder.set("#ModCards[" + i + "] #Disabled.Visible", false);
            uiCommandBuilder.set("#ModCards[" + i + "] #IncludesAssets.Visible", true);
            uiCommandBuilder.set("#ModCards[" + i + "] #IncludesAssets.Text", "Asset Pack");
            uiCommandBuilder.set("#ModCards[" + i + "] #ModLogo.Background", "pack_icon_not_found.png");
        } else {
            uiCommandBuilder.set("#ModCards[" + i + "] #Enabled.Visible", PluginManager.get().getPlugins().stream().anyMatch(plugin -> plugin.getManifest().equals(value)));
            uiCommandBuilder.set("#ModCards[" + i + "] #Disabled.Visible", PluginManager.get().getPlugins().stream().noneMatch(plugin -> plugin.getManifest().equals(value)));
            uiCommandBuilder.set("#ModCards[" + i + "] #IncludesAssets.Visible", value.includesAssetPack());
        }
        if (value.getWebsite() != null) {
            uiCommandBuilder.set("#ModCards[" + i + "] #Website.Text", value.getWebsite());
        } else {
            uiCommandBuilder.set("#ModCards[" + i + "] #Website.Visible", false);
        }
        String iconName = value.getGroup() + "_" + value.getName() + ".png";
        if (CommonAssetRegistry.hasCommonAsset((String)("UI/Custom/" + iconName))) {
            uiCommandBuilder.set("#ModCards[" + i + "] #ModLogo.Background", iconName);
        }
    }

    public static class SearchGuiData {
        static final String KEY_SHOW_ONLY_DESC = "ShowOnlyDesc";
        static final String KEY_SHOW_HYTALE = "ShowHytale";
        static final String KEY_SEARCH_QUERY = "@SearchQuery";
        public static final BuilderCodec<SearchGuiData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(SearchGuiData.class, SearchGuiData::new).addField(new KeyedCodec("@SearchQuery", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.searchQuery = s;
        }, searchGuiData -> searchGuiData.searchQuery)).addField(new KeyedCodec("ShowOnlyDesc", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.showOnlyDesc = s;
        }, searchGuiData -> searchGuiData.showOnlyDesc)).addField(new KeyedCodec("ShowHytale", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.showHytale = s;
        }, searchGuiData -> searchGuiData.showHytale)).build();
        private String showOnlyDesc;
        private String searchQuery;
        private String showHytale;
    }

    public class CustomManifest {
        public PluginManifest manifest;
        public boolean isAssetPack;

        public CustomManifest(ModListGui this$0, PluginManifest manifest, boolean isAssetPack) {
            Objects.requireNonNull(this$0);
            this.manifest = manifest;
            this.isAssetPack = isAssetPack;
        }
    }
}

